/******************************************************************************
Ootake
E荞ݗv󂯕tƂɁA荞ݗvNA悤ɂB
E荞ݗv󂯕tƂɁA荞݋֎~ǂ`FbN悤ɂ
  ֎~ꍇ荞ݗv͂̂܂܂ɂĂ(ȍ~荞߂)悤ɂ
  Bv0.64
EX^荞݃^C~O(IRQ1)ŏd邽߁A荞݂̗D揇ʂtƂ
  B
EDtOĂƂADCZŁA܂lĂȂsC
  B
ECSH,CSL߂̓BiCSL̓X^荞ݏ̎ԑ҂Ɏg邱
  Ƃj
E^C}[JE^͂ł͐i߂CPUƂ͖֌WŐi߂悤ɂB
E]ߒɂACPUȊO̓삪񓮍ł悤ɂB
ECPȔTCNꕔύXB
E荞ݏ̏TCN8(HuC6280BRKƓ)ɕύXB(@mF)
ECPȔTCNS1ɂ郂[hi^[{TCN[hjtB
  v1.61I[o[NbNj[ƓA̎ނ𑝂₵B
EPSGVvɂ_ClockUpCountsvƂB
EXe[gZ[u_ClockCount_ClockElapsedZ[u悤ɂB
E킩ɂȂȂ͈͓ŃTu[`炵čBv0.93
Eread(),write()֐}N邱ƂōBv1.07
Eϐւ̑ł邾炷ƂōBv1.08
E[y[Wւ̃ANZXKC($F8oN)ɌȂ(Ki
  ̏)Ƃ֑ΉBv1.29
E悭g閽ߌQɋLq邱ƂōBv1.30
ENbNŁA]߂TIATAÎ݂6TCN(lbg̎ł悭
  lĂ)ƂBOLQ߂VvTII,TDD,TIN5TCN(VDC
  ̃ANZXEFCg6TCN)ƂB@ł̑͂ĂȂAQ
  [̓Ƃ̎@ɍł߂Bv1.30
E荞ݏ̍ۂɁAIF̏Ԃ͖ߎsȌ(prevIF)悤ɂBW
  bNjNEXSt(HuJ[h)ŁAʍXĂ肪B
  v1.61

Copyright(C)2006-2020 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[CPU.c]

		Implements a HuC6280 Emulator.

	Copyright (C) 2004-2005 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
******************************************************************************/
#include "CPU.h"
#include "MainBoard.h"
#include "Printf.h"
#include "Debug.h"
#include "App.h"

Sint32 gCPU_ClockCount = 0; //v2.00ǉB̂߃JE^O[oB
Sint32 gCPU_Transfer;		//v2.31XVB̂߃JE^O[oB

static Uint8		_A;
static Uint8		_X;
static Uint8		_Y;
static Uint8		_S;
static Uint8		_P;
static Uint16		_PC;

static Uint8		_CF;
static Uint8		_ZF;
static Uint8		_IF;
static Uint8		_PrevIF; //KitaoǉBߊJnOItOۊǂĂBߌ̊荞ݏ邩ǂ̔fɂ͂(ߎsȌ)gBv1.61
static Uint8		_DF;
static Uint8		_BF;
static Uint8		_TF;
static Uint8		_VF;
static Uint8		_NF;

static Uint32		_MPR[8];

static Sint32		_ClockElapsed; //v1.61NbNpƂĂ͔gpBfobOɌ݂̖ߏTCNϐƂĎgpB
static BOOL			_bSpeedLow; //KitaoǉBLowSpeed[hiCSLߌĵƂTRUEB

static Uint16		_TransferSrcAddr; //Kitaoǉ
static Uint16		_TransferDstAddr; //Kitaoǉ
static Uint16		_TransferLength; //Kitaoǉ
static BOOL			_TransferIncDec; //KitaoǉBTRUEȂCNg

static BOOL			_bRDY;		// DMAv 
static BOOL			_bNMI;
static BOOL			_bIRQ1;
static BOOL			_bIRQ2;
static BOOL			_bTIRQ;
static BOOL			_bPrevIRQ1; //KitaoǉBPrevIFƋIRQ̏ԂAߊJnȌԂĝŁAۊǂĂBv1.61
static BOOL			_bPrevIRQ2; //
static BOOL			_bPrevTIRQ; //
static Uint8		_IntDisable; //Kitaoǉ
static Uint8		_PrevIntDisable; //KitaoǉBPrevIFƋɊ荞݂̋֎~ԂAߊJnȌԂĝŁAۊǂĂBv1.61

static Sint32		_SelectVDC; //KitaoǉBX[p[OtBbNXp

static BOOL			_bDebug = FALSE; //KitaoǉBv1.07
static Uint32		_OpCode = 0; //KitaoǉBv1.07
static Uint16		_PrevPC = 0; //KitaoǉBv1.07
static Uint8		_PrevFlags = 0; //KitaoǉBv1.07


// ǂݏo֐ 
static Uint8 (*ReadMem)(Uint32 mpr, Uint32 addr); //KitaoXVBv1.47

// ݊֐ 
static void (*WriteMem)(Uint32 mpr, Uint32 addr, Uint8 data); //KitaoXVBv1.47


static Sint32	_CycleTableBase[256] =
{
//KitaoXV
//  PLP(28),PLA(68)4TCNɂBlNXOPf@Ɠ^C~OɂȂB_uhSIIOPfŕKvBv1.61,v2.51XV
//  PHP(08)4TCNɂBlNXOPf@Ɠ^C~OɂȂBTUACYOP@ɋ߂Bv2.07XV
//  TCNύXӏ͎@łl͖mFłB
//	0 1 2  3 4 5 6 7 8 9 A B C D E F LoHi
	8,7,3, 4,6,4,6,7,4,2,2,2,7,5,7,6, //0
	2,7,7, 4,6,4,6,7,2,5,2,2,7,5,7,6, //1
	7,7,3, 4,4,4,6,7,4,2,2,2,5,5,7,6, //2
	2,7,7, 2,4,4,6,7,2,5,2,2,5,5,7,6, //3
	7,7,3, 4,7,4,6,7,3,2,2,2,4,5,7,6, //4  KitaoXVBR[h44(BSR)̒lύXBWṽTCNƍ킹ƍv7ɁB
	2,7,7, 5,2,4,6,7,2,5,3,2,2,5,7,6, //5  KitaoXVBR[h53(TAMi)̒lύXBI[NGXg̃^CgʂŕKvBR[h54(CSL)̒lύXBKi񂩂̊mȎɂHighLoŵƂ9TCN(7.159090MHzZ)BLowLow̏ꍇ̂łł2TCN̒lɂĂBoCIg\W[OKB
	7,7,2, 2,4,4,6,7,4,2,2,2,7,5,7,6, //6
	2,7,7,17,4,4,6,7,2,5,4,2,7,5,7,6, //7  KitaoǋLBR[h7A(PLY)3ɂƁA_uhSQOPfłpNȂBv2.55
	4,7,2, 7,4,4,4,7,2,2,2,2,5,5,5,6, //8  KitaoXVBR[h80(BRA)̒lύXBWṽTCNƍ킹ƍv4ɁB3ƃ{o[}'93̃X^[gfłPt[B
	2,7,7, 8,4,4,4,7,2,5,2,2,5,5,5,6, //9
	2,7,2, 7,4,4,4,7,2,2,2,2,5,5,5,6, //A
	2,7,7, 8,4,4,4,7,2,5,2,2,5,5,5,6, //B
	2,7,2,17,4,4,6,7,2,2,2,2,5,5,7,6, //C
	2,7,7,17,2,4,6,7,2,5,3,2,2,5,7,6, //D  KitaoXVBR[hD4(CSH)̒lύXBKi񂩂̊mȎɂLowHigĥƂ6TCN(7.159090MHzZ)BHighHigh̏ꍇ̂łł2TCN̒lɂĂBoCIg\W[OKB
	2,7,2,17,4,4,6,7,2,2,2,2,5,5,7,6, //E
	2,7,7,17,2,4,6,7,2,5,3,2,2,5,7,6  //F  KitaoǋLBR[hFA(PLX)4ɂƁA[hi[(pbNCrfI)X^[gɂBv2.51
};
static Sint32	_CycleTableSlow[256];
static Sint32	_CycleTableTurbo1[256];
static Sint32	_CycleTableTurbo2[256];
static Sint32*	_pCycleTable; //v1.61XV


//KitaoǉBv1.61
//ᑬ샂[h(CLS)̐ݒBᑬɐ؂ւȂTRUECʏ퍂[hɖ߂ȂFALSEŌĂԁB
static inline void
SetSpeedLow(
	BOOL	bSpeedLow)
{
	_bSpeedLow = bSpeedLow;
	if (VDC_GetOverClockType() < 100) //^[{TCN[ĥƂ͂̂܂܁BȊÕ[hȂ
	{
		if (_bSpeedLow)
			_pCycleTable = &_CycleTableSlow[0]; //LowSpeed[hiCSLߌĵƂ͂S{̃TCN|
		else//ʏ퍂[h
			_pCycleTable = &_CycleTableBase[0];
	}
}

//KitaoǉBv1.61
void
CPU_SetTurboCycle(
	Sint32	n)
{
	switch (n)
	{
		case 100: _pCycleTable = &_CycleTableTurbo1[0]; break; //^[{P{
		case 200: _pCycleTable = &_CycleTableTurbo2[0]; break; //^[{Q{
		case 300: _pCycleTable = &_CycleTableTurbo2[0]; break; //^[{R{BQ{ƓAɉVDC.cŃI[o[NbNB
		default: //0
			SetSpeedLow(_bSpeedLow);
	}
}


//KitaoǉBPrevIF(ߎsÕtOԂŎۂ̔fɎgl)XVBv1.61
static inline void
refreshPrevIF()
{
	_PrevIF = _IF;
	_bPrevIRQ1 = _bIRQ1;
	_bPrevIRQ2 = _bIRQ2;
	_bPrevTIRQ = _bTIRQ;
	_PrevIntDisable = _IntDisable;
}


/*-----------------------------------------------------------------------------
** Implement memory read/write stages
**---------------------------------------------------------------------------*/
//KitaoXVBread()write()֐Â߃Tu[`łȂ}NBv1.07
//			 }N`Ȃ̂READ(),WRITE(),READZP(),WRITEZP()ȊO̊֐(READINC()Ȃ)́AJbR≉Zɂ͋LqłȂB
//			 }N`Ȃ̂ňaddrɏdȂ֐≉Zq͏Ȃ悤ɂB
#define READ(addr)		ReadMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF))
#define READINC(addr)	ReadMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF)); addr++ //CNgp
#define READINC_X(addr)	ReadMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF)) + _X; addr++ //+_XCNgp
#define READINC_Y(addr)	ReadMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF)) + _Y; addr++ //+_YCNgp
#define READDEC(addr)	ReadMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF)); addr-- //fNgpB]ߎɎgpB
#define READZP(addr)	ReadMem(_MPR[1], addr) //[y[Wp
#define WRITE(addr,data)	WriteMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF), data)
#define WRITEINC(addr,data)	WriteMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF), data); addr++ //CNgp
#define WRITEDEC(addr,data)	WriteMem(_MPR[(addr) >> 13], ((addr) & 0x1FFF), data); addr-- //fNgp
#define WRITEZP(addr,data)	WriteMem(_MPR[1], addr, data) //[y[Wp


/*-----------------------------------------------------------------------------
** ($ZP)
*/
//KitaoXVB[y[WANZX̍ۂɁAMPR1̒lɂ$F8(CRAM)ȊÕoNɂANZXł悤ɂB
//			 Ki񂩂܂Bv1.29
static inline Uint16
fetchZpIndirect()
{
	Uint8	zpAddress;
	Uint16	low;

	zpAddress = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	low = ReadMem(_MPR[1], zpAddress++);
	return ((READZP(zpAddress) << 8) | low);
}

/*-----------------------------------------------------------------------------
** ($ZP,X)
*/
//KitaoXVBv1.29
static inline Uint16
fetchZpIndexIndirect()
{
	Uint8	zpAddress;
	Uint16	low;

	zpAddress = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF)) + _X;
	_PC++;
	low = ReadMem(_MPR[1], zpAddress++);
	return ((READZP(zpAddress) << 8) | low);
}

/*-----------------------------------------------------------------------------
** ($ZP),Y
*/
//KitaoXVBv1.29
static inline Uint16
fetchZpIndirectIndex()
{
	Uint8	zpAddress;
	Uint16	low;

	zpAddress = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	low = ReadMem(_MPR[1], zpAddress++);
	return ((READZP(zpAddress) << 8) | low) + _Y;
}

/*-----------------------------------------------------------------------------
** $ABS
*/
//KitaoXVBv1.07
static inline Uint16
fetchAbs()
{
	Uint16	low;
	Uint16	high;

	low = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	high = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	return ((high << 8) | low);
}

/*-----------------------------------------------------------------------------
** $ABS,X
*/
//KitaoXVBv1.07
static inline Uint16
fetchAbsX()
{
	Uint16	low;
	Uint16	high;

	low = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	high = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	return ((high << 8) | low) + _X;
}

/*-----------------------------------------------------------------------------
** $ABS,Y
*/
//KitaoXVBv1.07
static inline Uint16
fetchAbsY()
{
	Uint16	low;
	Uint16	high;

	low = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	high = ReadMem(_MPR[_PC >> 13], (_PC & 0x1FFF));
	_PC++;
	return ((high << 8) | low) + _Y;
}

/*-----------------------------------------------------------------------------
** ($ABS)
*/
//KitaoXVBv1.08
static inline Uint16
fetchAbsIndirect()
{
	Uint16	absAddr = fetchAbs();
	Uint16	low  = READINC(absAddr);
	return ((READ(absAddr) << 8) | low);
}

/*-----------------------------------------------------------------------------
** ($ABS,X)
*/
//KitaoXVBv1.08
static inline Uint16
fetchAbsIndirectX()
{
	Uint16	absAddr = fetchAbs() + _X;
	Uint16	low  = READINC(absAddr);
	return ((READ(absAddr) << 8) | low);
}


/*-----------------------------------------------------------------------------
** Implement stack operations
**---------------------------------------------------------------------------*/
static inline void
push(
	Uint8	reg8)
{
	WriteMem(_MPR[1], (0x100 | (_S--)), reg8);
}

static inline Uint8
pull()
{
	return ReadMem(_MPR[1], (0x100 | (++_S)));
}


/*-----------------------------------------------------------------------------
** Implement flag operations
** The idea is taken from nes6502.c by Matthew Conte.
**
** CF --- use CPU_CF (D0)
** ZF --- use 8-bit value
** IF --- use CPU_IF (D2)
** DF --- use CPU_DF (D3)
** BF --- use CPU_BF (D4)
** TF --- use CPU_TF (D5)
** VF --- use CPU_VF (D6)
** NF --- use 8-bit value
**---------------------------------------------------------------------------*/
static inline void
updateFlagZN(
	Uint8	val)
{
	_NF = _ZF = val;
}

static inline void
separateFlags(
	Uint8	p)
{
	_CF = p & CPU_CF;
	_ZF = ~(p >> 1) & 1;
	_IF = p & CPU_IF;
	_DF = p & CPU_DF;
	_BF = p & CPU_BF;
	_TF = p & CPU_TF;
	_VF = p;
	_NF = p;
}

static inline Uint8
gatherFlags()
{
	return _CF | ((_ZF==0)<<1) | _IF | _DF | _BF | _TF | (_VF&CPU_VF) | (_NF&CPU_NF);
}


/*-----------------------------------------------------------------------------
** Implement instruction execute stages
**---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
** BIT
*/
static inline void
bit(Uint8		val)
{
	_ZF = _A & val;
	_VF = _NF = val;
}

/*-----------------------------------------------------------------------------
** ADC
*/
static inline void
adc(Uint8		val)
{
	Uint32	lo;
	Uint32	hi;
	Uint32	sum;

	if (_DF)
	{
		//KitaoXVBl܂ȂƂsCBp[[OR̃z[ŔB
		lo = (_A & 0x0F) + (val & 0x0F) + _CF;
		hi = (_A & 0xF0) + (val & 0xF0);
		if (lo > 0x09)
		{
			hi += 0x10;
			lo += 0x06;
		}
		_VF = (Uint8)((~(_A^val) & (_A^hi) & CPU_NF) >> 1);
		if (hi > 0x90)
			hi += 0x60;
		_CF = (Uint8)((hi & 0x100) >> 8);
		updateFlagZN(_A = (Uint8)((lo & 0x0F) + (hi & 0xF0))); //KitaoXVB[tOlKeButOXVB
		gCPU_ClockCount--;
	}
	else
	{
		sum = _A + val + _CF;
		_VF = (Uint8)((~(_A^val) & (_A^sum) & CPU_NF) >> 1);
		_CF = (Uint8)((sum & 0x100) >> 8);
		updateFlagZN(_A = (Uint8)sum);
	}
}

/*-----------------------------------------------------------------------------
** ADC with T-flag set
*/
static inline void
adc_t(Uint8		val)
{
	Uint8	M = READZP(_X);
	Uint32	lo;
	Uint32	hi;
	Uint32	sum;

	if (_DF)
	{
		//KitaoXVBl܂ȂƂsCBp[[OR̃z[ŔB
		lo = (M & 0x0F) + (val & 0x0F) + _CF;
		hi = (M & 0xF0) + (val & 0xF0);
		if (lo > 0x09)
		{
			hi += 0x10;
			lo += 0x06;
		}
		_VF = (Uint8)((~(M^val) & (M^hi) & CPU_NF) >> 1);
		if (hi > 0x90)
			hi += 0x60;
		_CF = (Uint8)((hi & 0x100) >> 8);
		updateFlagZN(M = (Uint8)((lo & 0x0F) + (hi & 0xF0))); //KitaoXVB[tOlKeButOXVB
		gCPU_ClockCount -= 4; //v0.83XVB3TCN(Ki񂩂mȎ)B-1DtOԂ
	}
	else
	{
		sum = M + val + _CF;
		_VF = (Uint8)((~(M^val) & (M^sum) & CPU_NF) >> 1);
		_CF = (Uint8)((sum & 0x100) >> 8);
		updateFlagZN(M = (Uint8)sum);
		gCPU_ClockCount -= 3; //v0.83XVB3TCN(Ki񂩂mȎ)B
	}
	WRITEZP(_X, M);
}

/*-----------------------------------------------------------------------------
** SBC
*/
static inline void
sbc(Uint8		val)
{
	Uint32	flagC = (~_CF) & CPU_CF; // D0  v1.67XVUint32(炭킸ɍ)B
	Uint32	temp = _A - val - flagC;
	Uint32	lo;
	Uint32	hi;

	if (_DF)
	{
		lo = (_A & 0x0F) - (val & 0x0F) - flagC;
		hi = (_A >> 4) - (val >> 4) - ((lo & 0x10) == 0x10);
		if (lo & 0x10)
			lo -= 6;
		if (hi & 0x10)
			hi -= 6;
		_CF = (Uint8)((~hi & 0x10) >> 4);
		_VF = (Uint8)(((_A ^ temp) & (_A ^ val) & CPU_NF) >> 1);
		updateFlagZN(_A = (Uint8)((lo & 0x0F) | (hi << 4)));
		gCPU_ClockCount--;
	}
	else
	{
		_CF = (Uint8)((~temp & 0x100) >> 8);
		_VF = (Uint8)(((_A ^ temp) & (_A ^ val) & CPU_NF) >> 1);
		updateFlagZN(_A = (Uint8)temp);
	}
}

/*-----------------------------------------------------------------------------
** AND
*/
static inline void
and(Uint8		val)
{
	_A &= val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** AND with T-flag set
*/
static inline void
and_t(Uint8		val)
{
	Uint8 M = READZP(_X) & val;
	updateFlagZN(M);
	WRITEZP(_X, M);
	gCPU_ClockCount -= 3; //v0.83XVB3TCN(Ki񂩂mȎ)B
}

/*-----------------------------------------------------------------------------
** ASL
*/
static inline Uint8
asl(Uint8		val)
{
	_CF = val >> 7; //KitaoXVBv1.07
	updateFlagZN(val = val << 1); //KitaoXVBv1.07
	return val;
}

/*-----------------------------------------------------------------------------
** LSR
*/
static inline Uint8
lsr(Uint8		val)
{
	_CF = val & CPU_CF;	// bit0
	updateFlagZN(val = val >> 1); //KitaoXVBv1.07
	return val;
}

/*-----------------------------------------------------------------------------
** ROL
*/
static inline Uint8
rol(Uint8		val)
{
	Uint8 oldFlagC = _CF; // bit0
	_CF = val >> 7; //KitaoXVBv1.07
	updateFlagZN(val = (val << 1) | oldFlagC);
	return val;
}

/*-----------------------------------------------------------------------------
** ROR
*/
static inline Uint8
ror(Uint8		val)
{
	Uint8 oldFlagC = _CF << 7;
	_CF = val & CPU_CF;
	updateFlagZN(val = (val >> 1) | oldFlagC);
	return val;
}

/*-----------------------------------------------------------------------------
** CMP
*/
static inline void
cmp(Uint8		val)
{
	Uint32 temp = _A - val;

	updateFlagZN((Uint8)temp);
	_CF = (Uint8)((~temp & 0x100) >> 8);
}

/*-----------------------------------------------------------------------------
** CPX
*/
static inline void
cpx(Uint8		val)
{
	Uint32 temp = _X - val;

	updateFlagZN((Uint8)temp);
	_CF = (Uint8)((~temp & 0x100) >> 8);
}

/*-----------------------------------------------------------------------------
** CPY
*/
static inline void
cpy(Uint8		val)
{
	Uint32 temp = _Y - val;

	updateFlagZN((Uint8)temp);
	_CF = (Uint8)((~temp & 0x100) >> 8);
}

/*-----------------------------------------------------------------------------
** EOR
*/
static inline void
eor(Uint8		val)
{
	_A ^= val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** EOR with T-flag set
*/
static inline void
eor_t(Uint8		val)
{
	Uint8 M = READZP(_X) ^ val;
	updateFlagZN(M);
	WRITEZP(_X, M);
	gCPU_ClockCount -= 3; //v0.83XVB3TCN(Ki񂩂mȎ)B
}

/*-----------------------------------------------------------------------------
** ORA
*/
static inline void
ora(Uint8		val)
{
	_A |= val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** ORA with T-flag set
*/
static inline void
ora_t(Uint8		val)
{
	Uint8 M = READZP(_X) | val;
	updateFlagZN(M);
	WRITEZP(_X, M);
	gCPU_ClockCount -= 3; //v0.83XVB3TCN(Ki񂩂mȎ)B
}

/*-----------------------------------------------------------------------------
** LDA
*/
static inline void
lda(Uint8		val)
{
	_A = _NF = _ZF = val; //v1.47XV
}

/*-----------------------------------------------------------------------------
** LDX
*/
static inline void
ldx(Uint8		val)
{
	_X = _NF = _ZF = val; //v1.47XV
}

/*-----------------------------------------------------------------------------
** LDY
*/
static inline void
ldy(Uint8		val)
{
	_Y = _NF = _ZF = val; //v1.47XV
}

/*-----------------------------------------------------------------------------
** TAX
*/
static inline void
tax()
{
	_X = _A;
	updateFlagZN(_X);
}

/*-----------------------------------------------------------------------------
** TAY
*/
static inline void
tay()
{
	_Y = _A;
	updateFlagZN(_Y);
}

/*-----------------------------------------------------------------------------
** TXA
*/
static inline void
txa()
{
	_A = _X;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** TYA
*/
static inline void
tya()
{
	_A = _Y;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** TSX
*/
static inline void
tsx()
{
	_X = _S;
	updateFlagZN(_X);
}

/*-----------------------------------------------------------------------------
** BBRi (Branch on Bit Reset)
*/
static inline void
BBRi(const Uint8 bit)
{
	Uint8 addr8;
	Sint8 rel8;

	addr8 = READINC(_PC);
	rel8 = (Sint8)READINC(_PC);
	if ((READZP(addr8) & bit) == 0) //v1.29XV
	{
		gCPU_ClockCount--;
		gCPU_ClockCount--;
		_PC += (Sint16)rel8;
	}
}

/*-----------------------------------------------------------------------------
** BBSi (Branch on Bit Set)
*/
static inline void
BBSi(const Uint8 bit)
{
	Uint8 addr8;
	Sint8 rel8;

	addr8 = READINC(_PC);
	rel8 = (Sint8)READINC(_PC);
	if (READZP(addr8) & bit) //v1.29XV
	{
		gCPU_ClockCount--;
		gCPU_ClockCount--;
		_PC += (Sint16)rel8;
	}
}

/*-----------------------------------------------------------------------------
** TRB
*/
static inline Uint8
trb(Uint8		val)
{
	Uint8	M = ~_A & val;

	_VF = _NF = val;
	_ZF = M;
	return M;
}

/*-----------------------------------------------------------------------------
** TSB
*/
static inline Uint8
tsb(Uint8		val)
{
	Uint8	M = _A | val;

	_VF = _NF = val;
	_ZF = M;
	return M;
}

/*-----------------------------------------------------------------------------
** TST
*/
static inline void
tst(Uint8 imm, Uint8 M)
{
	_VF = _NF = M;
	_ZF = M & imm;
}

/*-----------------------------------------------------------------------------
** RMBi (Reset Memory Bit)
*/
static inline void
RMBi(Uint8 zp, Uint8 bit)
{
	WRITEZP(zp, READZP(zp) & (~bit));
}

/*-----------------------------------------------------------------------------
** SMBi (Set Memory Bit)
*/
static inline void
SMBi(Uint8 zp, Uint8 bit)
{
	WRITEZP(zp, READZP(zp) | bit);
}


/*-----------------------------------------------------------------------------
** Check for pending NMI / TIMER / IRQ1 / IRQ2
*/
//KitaoXVBX^荞݃^C~O(IRQ1)d邽߁A荞݂̗D揇ʂtƂB
static inline void
fetchInterrupt()
{
	if (_PrevIF == 0) //v1.61XVBߌ̊荞ݏ邩ǂ̔f́AߎsOItȌԂgB
	{
		if ((_bPrevIRQ2)&&((_PrevIntDisable & INTCTRL_IRQ2) == 0)) //v1.61XVBPrevIFlɁAߎsO̊荞݋֎~ԂgB
		{
			INTCTRL_Cancel(INTCTRL_IRQ2); //Kitaoǉ

			push(_PC >> 8);
			push(_PC & 0xFF);

			_BF = 0;
			push(gatherFlags());

			_IF = CPU_IF;
			_TF = _DF = 0;
			_PC  = READ(CPU_IRQ2VECTOR);
			_PC |= READ(CPU_IRQ2VECTOR + 1) << 8;
			gCPU_ClockCount -= 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
			return; //Kitaoǉ
		}
		
		if ((_bPrevIRQ1)&&((_PrevIntDisable & INTCTRL_IRQ1) == 0))
		{
			INTCTRL_Cancel(INTCTRL_IRQ1); //Kitaoǉ

			push(_PC >> 8);
			push(_PC & 0xFF);

			_BF = 0;
			push(gatherFlags());

			_IF = CPU_IF;
			_TF = _DF = 0;
			_PC  = READ(CPU_IRQ1VECTOR);
			_PC |= READ(CPU_IRQ1VECTOR + 1) << 8;
			gCPU_ClockCount -= 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
			return; //Kitaoǉ
		}
		
		if ((_bPrevTIRQ)&&((_PrevIntDisable & INTCTRL_TIRQ) == 0))
		{
			INTCTRL_Cancel(INTCTRL_TIRQ); //KitaoǉBNXCo[ŕKvB

			push(_PC >> 8);
			push(_PC & 0xFF);

			_BF = 0;
			push(gatherFlags());

			_IF = CPU_IF;
			_TF = _DF = 0;
			_PC  = READ(CPU_TIMERVECTOR);
			_PC |= READ(CPU_TIMERVECTOR + 1) << 8;
			gCPU_ClockCount -= 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
			return; //Kitaoǉ
		}
	}

/*	if (_bNMI) //KitaoXVB݃G~[^ł͖gp
	{
		push(_PC >> 8);
		push(_PC & 0xFF);

		// B tO̓NAꂽɃX^bN֑ޔB
		_BF = 0;
		push(gatherFlags());

		_IF = CPU_IF;
		refreshPrevIF(); //v1.61ǉ
		_TF = _DF = 0;
		_PC  = READ(CPU_NMIVECTOR);
		_PC |= READ(CPU_NMIVECTOR + 1) << 8;
		gCPU_ClockCount -= 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
	}
*/
}


/******************************************************************************
**							   OJ֐
******************************************************************************/


/*-----------------------------------------------------------------------------
** [CPU_SetReadFunction]
**	 oNƂ̃[h֐o^܂B(K{)
**---------------------------------------------------------------------------*/
void
CPU_SetReadFunction(Uint8 (*RdFunc)(Uint32, Uint32)) //KitaoXVB}bsOWX^ƃAhXʂɎ󂯎悤ɂčBv1.47
{
	ReadMem = RdFunc;
}

/*-----------------------------------------------------------------------------
** [CPU_SetWriteFunction]
**	 oNƂ̃Cg֐o^܂B(K{)
**---------------------------------------------------------------------------*/
void
CPU_SetWriteFunction(void (*WrFunc)(Uint32, Uint32, Uint8)) //KitaoXVB}bsOWX^ƃAhXʂɎ󂯎悤ɂčBv1.47
{
	WriteMem = WrFunc;
}


/*-----------------------------------------------------------------------------
** [Reset]
** botRAZbg܂BNbNԂ܂B
**---------------------------------------------------------------------------*/
Sint32
CPU_Reset()
{
	int		i;

	for (i=0; i<256; i++)
	{
		_CycleTableSlow[i] = _CycleTableBase[i] << 2; //LowSpeed[hiCSLߌĵƂ͂S{̃TCN|
		_CycleTableTurbo1[i] = 2; //OotakeƎTurbo[h1̂Ƃ͑SĂ̖ߎs2TCNƂB
		_CycleTableTurbo2[i] = 1; //OotakeƎTurbo[h2̂Ƃ͑SĂ̖ߎs1TCNƂ(v1.60ȑÕ^[{TCN)B
	}
	SetSpeedLow(FALSE); //Kitaoǉ
	gCPU_Transfer = 0; //Kitaoǉ

	//Kitaoǉ
	_bRDY = FALSE;
	_bIRQ1 = FALSE;
	_bIRQ2 = FALSE;
	_bTIRQ = FALSE;
	_bNMI = FALSE;
	_IntDisable = 0;

	//KitaoǉBÔ߂ɓdē͑StO
	_CF = 0;
	_ZF = 0;
	_IF = CPU_IF; //v1.61XV
	refreshPrevIF(); //v1.61ǉB_bPrevIRQx,_PrevIntDisableXVB
	_DF = 0;
	_BF = 0;
	_TF = 0;
	_VF = 0;
	_NF = 0;

	ZeroMemory(_MPR, sizeof(_MPR)); //KitaoXVBÔ߂ɓdē̓}bsOWX^SďB

	//KitaoǉBÔ߂ɓdē͑StO
	_A = 0;
	_X = 0;
	_Y = 0;
	_S = 0;
	_P = 0;
	_PC = READ(CPU_RESETVECTOR);
	_PC |= READ(CPU_RESETVECTOR + 1) << 8;

	//KitaoǉBX[p[OtBbNXp
	_SelectVDC = 0;

	gCPU_ClockCount = -6;
	_ClockElapsed = 0;

	return 6;
}


/*-----------------------------------------------------------------------------
** [CPU_ActivateRDY]
**	 cl`vqcxANeBuɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_ActivateRDY()
{
	_bRDY = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateNMI]
**	 ݓ͐mlhANeBuɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_ActivateNMI()
{
	_bNMI = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateTIMER]
**	 ^C}[ݗvshldqANeBuɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_ActivateTIMER()
{
	_bTIRQ = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateIRQ1]
**	 ݓ͐hqpPANeBuɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_ActivateIRQ1()
{
	_bIRQ1 = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateIRQ2]
**	 ݓ͐hqpQANeBuɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_ActivateIRQ2()
{
	_bIRQ2 = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateRDY]
**	 cl`vqcx𖳌ɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_InactivateRDY()
{
	_bRDY = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateNMI]
**	 ݓ͐mlh𖳌ɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_InactivateNMI()
{
	_bNMI = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateTIMER]
**	 ^C}[ݗvshldq𖳌ɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_InactivateTIMER()
{
	_bTIRQ = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateIRQ1]
**	 ݓ͐hqpP𖳌ɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_InactivateIRQ1()
{
	_bIRQ1 = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateIRQ2]
**	 ݓ͐hqpQ𖳌ɂ܂B
**---------------------------------------------------------------------------*/
void
CPU_InactivateIRQ2()
{
	_bIRQ2 = FALSE;
}


/*-----------------------------------------------------------------------------
** [CPU_Setxx]
**	 WX^̒lݒ肵܂B 
**---------------------------------------------------------------------------*/
void CPU_SetA(Uint8 A) { _A = A; }
void CPU_SetX(Uint8 X) { _X = X; }
void CPU_SetY(Uint8 Y) { _Y = Y; }
void CPU_SetS(Uint8 S) { _S = S; }
void CPU_SetP(Uint8 P) { _P = P; separateFlags(P); }
void CPU_SetPC(Uint16 PC) { _PC = PC; }
void CPU_SetMPR(Sint32 i, Uint32 mpr) { _MPR[i] = mpr; }


/*-----------------------------------------------------------------------------
** [CPU_Getxx]
**	 WX^̒l擾܂B 
**---------------------------------------------------------------------------*/
Uint8 CPU_GetA() { return _A; }
Uint8 CPU_GetX() { return _X; }
Uint8 CPU_GetY() { return _Y; }
Uint8 CPU_GetS() { return _S; }
Uint8 CPU_GetP() { _P = gatherFlags(); return _P; }
Uint16 CPU_GetPC() { return _PC; }
Uint32 CPU_GetMPR(Sint32 i) { return _MPR[i]; }


//Kitaoǉ
void
CPU_WriteMemory(
	Uint32	addr,
	Uint8	data)
{
	WRITE(addr, data);
}

//Kitaoǉ
void
CPU_WriteMemoryZero(
	Uint8	addr,
	Uint8	data)
{
	WRITEZP(addr, data);
}

//Kitaoǉ
void
CPU_WriteMemoryMpr(
	Uint32	mpr,
	Uint32	addr,
	Uint8	data,
	BOOL	bContinuous) //t[AlXVȂbContinuousTRUEŌĂԁBv2.39
{
	mpr  &= 0xFF;

	if (APP_GetCDGame())
	{
		if (mpr <= 0x3F)
			MAINBOARD_WriteROM(mpr, (addr & 0x1FFF), data); //ROM̈̏ꍇ
		else
			WriteMem(mpr, (addr & 0x1FFF), data);
	}
	else
	{
		if (mpr <= 0x7F)
			MAINBOARD_WriteROM(mpr, (addr & 0x1FFF), data); //ROM̈̏ꍇ
		else
			WriteMem(mpr, (addr & 0x1FFF), data);
	}
	
	MAINBOARD_SetContinuousWriteValue(bContinuous, mpr,addr,data); //ładdrۂߍ(&0x1FFF)Ô̂܂܂̃AhXn
}


//KitaoǉB荞݋֎~̐ݒ
void
CPU_SetIntDisable(
	Uint8	intDisable)
{
	_IntDisable = intDisable;
}


//KitaoǉBX[p[OtBbNXpBST0,ST1,ST2߂ǂVDCANZXΏۂɂ邩ݒB
void
CPU_SelectVDC(
	Sint32	selectVDC)	//selectVDCc01
{
	_SelectVDC = selectVDC;
}


//KitaoǉBfobO[h̐ݒBv1.07
void
CPU_SetDebug(
	BOOL	debug)
{
	_bDebug = debug;
}

//KitaoǉBݎs̖߃R[hԂBfobOpBv1.07
Uint32
CPU_GetOpCode()
{
	return _OpCode;
}

//KitaoǉBfobOpBv1.07
Uint8
CPU_ReadCode(
	Uint16	pc)
{
	return READ(pc);
}

//KitaoǉBݎs̖߂_PCԂBfobOpBv1.07
Uint16
CPU_GetPrevPC()
{
	return _PrevPC;
}

//KitaoǉBfobOpBv1.07
Uint8
CPU_GetPrevFlags()
{
	return _PrevFlags;
}

//KitaoǉBݎs̖߂̏NbNԂBVDCANZXɃEFCg邩ǂ̔fŎgpBݔgp
Sint32
CPU_GetClockElapsed()
{
	return _ClockElapsed;
}


//KitaoXVB^C~O@ɋ߂Â邽߂ɁACSL߂̎Ɗ荞݊֘AύXB
//			 荞݃tOʒuύXBCPU_AdvanceClock()inlineɂčBv1.61B
void  //v0.94LBɂƎv傫ƂinlineȂقPC̃LbVɎ܂Ĉ肵ۂĂĂB
CPU_ExecuteOperation()
{
	Uint8	ureg8;
	Uint8	addr8;
	Sint8	rel8;
	Uint16	addr16;

	//KitaoǉB@̃^C~Oɍ킹邽߁AubN]VDCƕɓ삳悤ɂB
	switch (gCPU_Transfer) //gCPU_Transferc1=TII,2=TDD,3=TIN,4=TIA,5=TAI  v1.14XVBgCPU_Transfer̔PɂčB
	{
	case 0: //]ߒł͂Ȃʏ̏ꍇ
		if (_bDebug)
		{	//v1.07ǉBfobOEBhE\Ȃ
			while (DEBUG_GetPause()) //fobOEBhEŒ~ݒ蒆Ȃ܂ő҂
				Sleep(1);
			if (DEBUG_GetPauseLong()) //ꎞIȉ̏ꍇ
				DEBUG_SetPause(TRUE); //Pߎs܂|[Y
			
			fetchInterrupt();
			refreshPrevIF();
			_PrevPC = _PC;
			_PrevFlags = gatherFlags();
		}
		else //ʏ
		{
			//KitaoXVB߂sOɊ荞ݏs悤ɂBv1.61XV
			//			 荞ݏ󋵂̃`FbŃAЂƂO̖ߊJnItO荞ݐMԂQƂB
			//			 WbNjNEXSt(HuJ[h)ŃVbgʗꂪBXgQfŋHɂPt[邱ƂB
			//			 tH[[VTbJ['90̃GfBOŕKvBItOƊ荞݋֎~łȂIRQPrevIRQŌ邱Ƃ^GWFŕKvB
			fetchInterrupt();
			refreshPrevIF(); //̊荞ݏp_PrevIF,_PrevIRQx,_PrevIntDisableɌ݂̏󋵂ۊǁBv1.61ǉ
		}

		_OpCode = READINC(_PC);
		gCPU_ClockCount -= _pCycleTable[_OpCode]; //v1.61XVB͒gCPU_ClockCount悤ɂBB
		//gCPU_ClockCount -= (_ClockElapsed = _pCycleTable[_OpCode]); //̂ߌݔgpBfobOp

		//KitaoXVB悭g閽߂ɎĂčBv1.30B[vŎgꂻȖ߂ɁBv1.63XVB
		switch (_OpCode)
		{
			/*-------------------------------------------------------------------**
			** register data transfer instructions
			**-------------------------------------------------------------------*/
			/*---- LDA ----------------------------------------------------------*/
			case CPU_INST_LDA_IMM:
				ureg8 = READINC(_PC);
				lda(ureg8);
				break;

			case CPU_INST_LDA_ZP:
				addr8 = READINC(_PC);
				lda(READZP(addr8));
				break;

			case CPU_INST_LDA_ZP_X:
				addr8 = READINC_X(_PC);
				lda(READZP(addr8));
				break;

			case CPU_INST_LDA_IND:
				addr16 = fetchZpIndirect();
				lda(READ(addr16));
				break;

			case CPU_INST_LDA_IND_X:
				addr16 = fetchZpIndexIndirect();
				lda(READ(addr16));
				break;

			case CPU_INST_LDA_IND_Y:
				addr16 = fetchZpIndirectIndex();
				lda(READ(addr16));
				break;

			case CPU_INST_LDA_ABS:
				addr16 = fetchAbs();
				lda(READ(addr16));
				break;

			case CPU_INST_LDA_ABS_X:
				addr16 = fetchAbsX();
				lda(READ(addr16));
				break;

			case CPU_INST_LDA_ABS_Y:
				addr16 = fetchAbsY();
				lda(READ(addr16));
				break;

			/*---- LDX ----------------------------------------------------------*/
			case CPU_INST_LDX_IMM:
				ureg8 = READINC(_PC);
				ldx(ureg8);
				break;

			case CPU_INST_LDX_ZP:
				addr8 = READINC(_PC);
				ldx(READZP(addr8));
				break;

			case CPU_INST_LDX_ZP_Y:
				addr8 = READINC_Y(_PC);
				ldx(READZP(addr8));
				break;

			case CPU_INST_LDX_ABS:
				addr16 = fetchAbs();
				ldx(READ(addr16));
				break;

			case CPU_INST_LDX_ABS_Y:
				addr16 = fetchAbsY();
				ldx(READ(addr16));
				break;

			/*---- LDY ----------------------------------------------------------*/
			case CPU_INST_LDY_IMM:
				ureg8 = READINC(_PC);
				ldy(ureg8);
				break;

			case CPU_INST_LDY_ZP:
				addr8 = READINC(_PC);
				ldy(READZP(addr8));
				break;

			case CPU_INST_LDY_ZP_X:
				addr8 = READINC_X(_PC);
				ldy(READZP(addr8));
				break;

			case CPU_INST_LDY_ABS:
				addr16 = fetchAbs();
				ldy(READ(addr16));
				break;

			case CPU_INST_LDY_ABS_X:
				addr16 = fetchAbsX();
				ldy(READ(addr16));
				break;

			/*---- STA ----------------------------------------------------------*/
			case CPU_INST_STA_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, _A);
				break;

			case CPU_INST_STA_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, _A);
				break;

			case CPU_INST_STA_IND:
				addr16 = fetchZpIndirect();
				WRITE(addr16, _A);
				break;

			case CPU_INST_STA_IND_X:
				addr16 = fetchZpIndexIndirect();
				WRITE(addr16, _A);
				break;

			case CPU_INST_STA_IND_Y:
				addr16 = fetchZpIndirectIndex();
				WRITE(addr16, _A);
				break;

			case CPU_INST_STA_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, _A);
				break;

			case CPU_INST_STA_ABS_X:
				addr16 = fetchAbsX();
				WRITE(addr16, _A);
				break;

			case CPU_INST_STA_ABS_Y:
				addr16 = fetchAbsY();
				WRITE(addr16, _A);
				break;

			/*---- STX ----------------------------------------------------------*/
			case CPU_INST_STX_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, _X);
				break;

			case CPU_INST_STX_ZP_Y:
				addr8 = READINC_Y(_PC);
				WRITEZP(addr8, _X);
				break;

			case CPU_INST_STX_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, _X);
				break;

			/*---- STY ----------------------------------------------------------*/
			case CPU_INST_STY_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, _Y);
				break;

			case CPU_INST_STY_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, _Y);
				break;

			case CPU_INST_STY_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, _Y);
				break;

			/*---- ST0 ----------------------------------------------------------*/
			case CPU_INST_ST0_IMM:
				ureg8 = READINC(_PC);
				if (_SelectVDC == 0) //KitaoXVBX[p[OtBbNXp
					WriteMem(0xFF, 0x0000, ureg8);
				else
					WriteMem(0xFF, 0x0010, ureg8);
				break;

			/*---- ST1 ----------------------------------------------------------*/
			case CPU_INST_ST1_IMM:
				ureg8 = READINC(_PC);
				if (_SelectVDC == 0) //KitaoXVBX[p[OtBbNXp
					WriteMem(0xFF, 0x0002, ureg8);
				else
					WriteMem(0xFF, 0x0012, ureg8);
				break;

			/*---- ST2 ----------------------------------------------------------*/
			case CPU_INST_ST2_IMM:
				ureg8 = READINC(_PC);
				if (_SelectVDC == 0) //KitaoXVBX[p[OtBbNXp
					WriteMem(0xFF, 0x0003, ureg8);
				else
					WriteMem(0xFF, 0x0013, ureg8);
				break;

			/*---- STZ ----------------------------------------------------------*/
			case CPU_INST_STZ_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, 0);
				break;

			case CPU_INST_STZ_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, 0);
				break;

			case CPU_INST_STZ_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, 0);
				break;

			case CPU_INST_STZ_ABS_X:
				addr16 = fetchAbsX();
				WRITE(addr16, 0);
				break;

			/*-------------------------------------------------------------------**
			** flag instructions
			**-------------------------------------------------------------------*/
			/*---- CLC ----------------------------------------------------------*/
			case CPU_INST_CLC:
				_CF = 0;
				break;

			/*---- CLD ----------------------------------------------------------*/
			case CPU_INST_CLD:
				_DF = 0;
				break;

			/*---- CLI ----------------------------------------------------------*/
			case CPU_INST_CLI:
				//KitaoXVBItONAIRQ ̃tFb`sȂBlNX̗vǂ̃I[vjOŃt[YȂ߂ɕKvB
				//			 荞ݓVvɂ̂ŁAWbL[`FȂNB
				_IF = 0;
				break;

			/*---- CLV ----------------------------------------------------------*/
			case CPU_INST_CLV:
				_VF = 0;
				break;

			/*---- SEC ----------------------------------------------------------*/
			case CPU_INST_SEC:
				_CF = CPU_CF;
				break;

			/*---- SED ----------------------------------------------------------*/
			case CPU_INST_SED:
				_DF = CPU_DF;
				break;

			/*---- SEI ----------------------------------------------------------*/
			case CPU_INST_SEI:
				//KitaoǋLBQlFItOZbgOɊ荞݃tFb`sƁAt@C[vXOŉʉNB
				_IF = CPU_IF;
				break;

			/*---- SET ----------------------------------------------------------*/
			case CPU_INST_SET:
				_TF = CPU_TF;
				return; // TtOZbgɎ̖߂

			/*-------------------------------------------------------------------**
			** ALU instructions
			**-------------------------------------------------------------------*/
			/*---- ADC ----------------------------------------------------------*/
			case CPU_INST_ADC_IMM:
				ureg8 = READINC(_PC);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_ZP:
				ureg8 = READINC(_PC);
				if (_TF)
					adc_t(READZP(ureg8));
				else
					adc(READZP(ureg8));
				break;

			case CPU_INST_ADC_ZP_X:
				ureg8 = READINC_X(_PC);
				if (_TF)
					adc_t(READZP(ureg8));
				else
					adc(READZP(ureg8));
				break;

			case CPU_INST_ADC_IND:
				addr16 = fetchZpIndirect();
				if (_TF)
					adc_t(READ(addr16)); //KitaoXVBureg8ւ̑ȗčBȉ̖߂lɍXVBv1.08
				else
					adc(READ(addr16));
				break;

			case CPU_INST_ADC_IND_X:
				addr16 = fetchZpIndexIndirect();
				if (_TF)
					adc_t(READ(addr16));
				else
					adc(READ(addr16));
				break;

			case CPU_INST_ADC_IND_Y:
				addr16 = fetchZpIndirectIndex();
				if (_TF)
					adc_t(READ(addr16));
				else
					adc(READ(addr16));
				break;

			case CPU_INST_ADC_ABS:
				addr16 = fetchAbs();
				if (_TF)
					adc_t(READ(addr16));
				else
					adc(READ(addr16));
				break;

			case CPU_INST_ADC_ABS_X:
				addr16 = fetchAbsX();
				if (_TF)
					adc_t(READ(addr16));
				else
					adc(READ(addr16));
				break;

			case CPU_INST_ADC_ABS_Y:
				addr16 = fetchAbsY();
				if (_TF)
					adc_t(READ(addr16));
				else
					adc(READ(addr16));
				break;

			/*---- SBC ----------------------------------------------------------*/
			case CPU_INST_SBC_IMM:
				ureg8 = READINC(_PC);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_ZP:
				ureg8 = READINC(_PC);
				sbc(READZP(ureg8));
				break;

			case CPU_INST_SBC_ZP_X:
				ureg8 = READINC_X(_PC);
				sbc(READZP(ureg8));
				break;

			case CPU_INST_SBC_IND:
				addr16 = fetchZpIndirect();
				sbc(READ(addr16));
				break;

			case CPU_INST_SBC_IND_X:
				addr16 = fetchZpIndexIndirect();
				sbc(READ(addr16));
				break;

			case CPU_INST_SBC_IND_Y:
				addr16 = fetchZpIndirectIndex();
				sbc(READ(addr16));
				break;

			case CPU_INST_SBC_ABS:
				addr16 = fetchAbs();
				sbc(READ(addr16));
				break;

			case CPU_INST_SBC_ABS_X:
				addr16 = fetchAbsX();
				sbc(READ(addr16));
				break;

			case CPU_INST_SBC_ABS_Y:
				addr16 = fetchAbsY();
				sbc(READ(addr16));
				break;

			/*---- AND ----------------------------------------------------------*/
			case CPU_INST_AND_IMM:
				ureg8 = READINC(_PC);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_ZP:
				ureg8 = READINC(_PC);
				if (_TF)
					and_t(READZP(ureg8));
				else
					and(READZP(ureg8));
				break;

			case CPU_INST_AND_ZP_X:
				ureg8 = READINC_X(_PC);
				if (_TF)
					and_t(READZP(ureg8));
				else
					and(READZP(ureg8));
				break;

			case CPU_INST_AND_IND:
				addr16 = fetchZpIndirect();
				if (_TF)
					and_t(READ(addr16));
				else
					and(READ(addr16));
				break;

			case CPU_INST_AND_IND_X:
				addr16 = fetchZpIndexIndirect();
				if (_TF)
					and_t(READ(addr16));
				else
					and(READ(addr16));
				break;

			case CPU_INST_AND_IND_Y:
				addr16 = fetchZpIndirectIndex();
				if (_TF)
					and_t(READ(addr16));
				else
					and(READ(addr16));
				break;

			case CPU_INST_AND_ABS:
				addr16 = fetchAbs();
				if (_TF)
					and_t(READ(addr16));
				else
					and(READ(addr16));
				break;

			case CPU_INST_AND_ABS_X:
				addr16 = fetchAbsX();
				if (_TF)
					and_t(READ(addr16));
				else
					and(READ(addr16));
				break;

			case CPU_INST_AND_ABS_Y:
				addr16 = fetchAbsY();
				if (_TF)
					and_t(READ(addr16));
				else
					and(READ(addr16));
				break;

			/*---- ORA ----------------------------------------------------------*/
			case CPU_INST_ORA_IMM:
				ureg8 = READINC(_PC);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_ZP:
				ureg8 = READINC(_PC);
				if (_TF)
					ora_t(READZP(ureg8));
				else
					ora(READZP(ureg8));
				break;

			case CPU_INST_ORA_ZP_X:
				ureg8 = READINC_X(_PC);
				if (_TF)
					ora_t(READZP(ureg8));
				else
					ora(READZP(ureg8));
				break;

			case CPU_INST_ORA_IND:
				addr16 = fetchZpIndirect();
				if (_TF)
					ora_t(READ(addr16));
				else
					ora(READ(addr16));
				break;

			case CPU_INST_ORA_IND_X:
				addr16 = fetchZpIndexIndirect();
				if (_TF)
					ora_t(READ(addr16));
				else
					ora(READ(addr16));
				break;

			case CPU_INST_ORA_IND_Y:
				addr16 = fetchZpIndirectIndex();
				if (_TF)
					ora_t(READ(addr16));
				else
					ora(READ(addr16));
				break;

			case CPU_INST_ORA_ABS:
				addr16 = fetchAbs();
				if (_TF)
					ora_t(READ(addr16));
				else
					ora(READ(addr16));
				break;

			case CPU_INST_ORA_ABS_X:
				addr16 = fetchAbsX();
				if (_TF)
					ora_t(READ(addr16));
				else
					ora(READ(addr16));
				break;

			case CPU_INST_ORA_ABS_Y:
				addr16 = fetchAbsY();
				if (_TF)
					ora_t(READ(addr16));
				else
					ora(READ(addr16));
				break;

			/*---- EOR ----------------------------------------------------------*/
			case CPU_INST_EOR_IMM:
				ureg8 = READINC(_PC);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_ZP:
				ureg8 = READINC(_PC);
				if (_TF)
					eor_t(READZP(ureg8));
				else
					eor(READZP(ureg8));
				break;

			case CPU_INST_EOR_ZP_X:
				ureg8 = READINC_X(_PC);
				if (_TF)
					eor_t(READZP(ureg8));
				else
					eor(READZP(ureg8));
				break;

			case CPU_INST_EOR_IND:
				addr16 = fetchZpIndirect();
				if (_TF)
					eor_t(READ(addr16));
				else
					eor(READ(addr16));
				break;

			case CPU_INST_EOR_IND_X:
				addr16 = fetchZpIndexIndirect();
				if (_TF)
					eor_t(READ(addr16));
				else
					eor(READ(addr16));
				break;

			case CPU_INST_EOR_IND_Y:
				addr16 = fetchZpIndirectIndex();
				if (_TF)
					eor_t(READ(addr16));
				else
					eor(READ(addr16));
				break;

			case CPU_INST_EOR_ABS:
				addr16 = fetchAbs();
				if (_TF)
					eor_t(READ(addr16));
				else
					eor(READ(addr16));
				break;

			case CPU_INST_EOR_ABS_X:
				addr16 = fetchAbsX();
				if (_TF)
					eor_t(READ(addr16));
				else
					eor(READ(addr16));
				break;

			case CPU_INST_EOR_ABS_Y:
				addr16 = fetchAbsY();
				if (_TF)
					eor_t(READ(addr16));
				else
					eor(READ(addr16));
				break;

			/*---- INC ----------------------------------------------------------*/
			case CPU_INST_INC_ACCUM:
				updateFlagZN(++_A);
				break;

			case CPU_INST_INC_ZP:
				addr8 = READINC(_PC);
				ureg8 = READZP(addr8);
				updateFlagZN(++ureg8);
				WRITEZP(addr8, ureg8);
				break;

			case CPU_INST_INC_ZP_X:
				addr8 = READINC_X(_PC);
				ureg8 = READZP(addr8);
				updateFlagZN(++ureg8);
				WRITEZP(addr8, ureg8);
				break;

			case CPU_INST_INC_ABS:
				addr16 = fetchAbs();
				ureg8 = READ(addr16);
				updateFlagZN(++ureg8);
				WRITE(addr16, ureg8);
				break;

			case CPU_INST_INC_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = READ(addr16);
				updateFlagZN(++ureg8);
				WRITE(addr16, ureg8);
				break;

			/*---- INX ----------------------------------------------------------*/
			case CPU_INST_INX:
				updateFlagZN(++_X);
				break;

			/*---- INY ----------------------------------------------------------*/
			case CPU_INST_INY:
				updateFlagZN(++_Y);
				break;

			/*---- DEC ----------------------------------------------------------*/
			case CPU_INST_DEC_ACCUM:
				updateFlagZN(--_A);
				break;

			case CPU_INST_DEC_ZP:
				addr8 = READINC(_PC);
				ureg8 = READZP(addr8);
				updateFlagZN(--ureg8);
				WRITEZP(addr8, ureg8);
				break;

			case CPU_INST_DEC_ZP_X:
				addr8 = READINC_X(_PC);
				ureg8 = READZP(addr8);
				updateFlagZN(--ureg8);
				WRITEZP(addr8, ureg8);
				break;

			case CPU_INST_DEC_ABS:
				addr16 = fetchAbs();
				ureg8 = READ(addr16);
				updateFlagZN(--ureg8);
				WRITE(addr16, ureg8);
				break;

			case CPU_INST_DEC_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = READ(addr16);
				updateFlagZN(--ureg8);
				WRITE(addr16, ureg8);
				break;

			/*---- DEX ----------------------------------------------------------*/
			case CPU_INST_DEX:
				updateFlagZN(--_X);
				break;
					
			/*---- DEY ----------------------------------------------------------*/
			case CPU_INST_DEY:
				updateFlagZN(--_Y);
				break;

			/*---- CMP ----------------------------------------------------------*/
			case CPU_INST_CMP_IMM:
				ureg8 = READINC(_PC);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_ZP:
				ureg8 = READINC(_PC);
				cmp(READZP(ureg8));
				break;

			case CPU_INST_CMP_ZP_X:
				ureg8 = READINC_X(_PC);
				cmp(READZP(ureg8));
				break;

			case CPU_INST_CMP_IND:
				addr16 = fetchZpIndirect();
				cmp(READ(addr16));
				break;

			case CPU_INST_CMP_IND_X:
				addr16 = fetchZpIndexIndirect();
				cmp(READ(addr16));
				break;

			case CPU_INST_CMP_IND_Y:
				addr16 = fetchZpIndirectIndex();
				cmp(READ(addr16));
				break;

			case CPU_INST_CMP_ABS:
				addr16 = fetchAbs();
				cmp(READ(addr16));
				break;

			case CPU_INST_CMP_ABS_X:
				addr16 = fetchAbsX();
				cmp(READ(addr16));
				break;

			case CPU_INST_CMP_ABS_Y:
				addr16 = fetchAbsY();
				cmp(READ(addr16));
				break;

			/*---- CPX ----------------------------------------------------------*/
			case CPU_INST_CPX_IMM:
				ureg8 = READINC(_PC);
				cpx(ureg8);
				break;

			case CPU_INST_CPX_ZP:
				ureg8 = READINC(_PC);
				cpx(READZP(ureg8));
				break;
			
			case CPU_INST_CPX_ABS:
				addr16 = fetchAbs();
				cpx(READ(addr16));
				break;

			/*---- CPY ----------------------------------------------------------*/
			case CPU_INST_CPY_IMM:
				ureg8 = READINC(_PC);
				cpy(ureg8);
				break;

			case CPU_INST_CPY_ZP:
				ureg8 = READINC(_PC);
				cpy(READZP(ureg8));
				break;
			
			case CPU_INST_CPY_ABS:
				addr16 = fetchAbs();
				cpy(READ(addr16));
				break;

			/*---- ASL ----------------------------------------------------------*/
			case CPU_INST_ASL_ACCUM:
				_A = asl(_A);
				break;

			case CPU_INST_ASL_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, asl(READZP(addr8)));
				break;

			case CPU_INST_ASL_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, asl(READZP(addr8)));
				break;

			case CPU_INST_ASL_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, asl(READ(addr16)));
				break;
			
			case CPU_INST_ASL_ABS_X:
				addr16 = fetchAbsX();
				WRITE(addr16, asl(READ(addr16)));
				break;

			/*---- LSR ----------------------------------------------------------*/
			case CPU_INST_LSR_ACCUM:
				_A = lsr(_A);
				break;

			case CPU_INST_LSR_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, lsr(READZP(addr8)));
				break;

			case CPU_INST_LSR_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, lsr(READZP(addr8)));
				break;

			case CPU_INST_LSR_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, lsr(READ(addr16)));
				break;
			
			case CPU_INST_LSR_ABS_X:
				addr16 = fetchAbsX();
				WRITE(addr16, lsr(READ(addr16)));
				break;

			/*---- ROL ----------------------------------------------------------*/
			case CPU_INST_ROL_ACCUM:
				_A = rol(_A);
				break;

			case CPU_INST_ROL_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, rol(READZP(addr8)));
				break;

			case CPU_INST_ROL_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, rol(READZP(addr8)));
				break;

			case CPU_INST_ROL_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, rol(READ(addr16)));
				break;
			
			case CPU_INST_ROL_ABS_X:
				addr16 = fetchAbsX();
				WRITE(addr16, rol(READ(addr16)));
				break;

			/*---- ROR ----------------------------------------------------------*/
			case CPU_INST_ROR_ACCUM:
				_A = ror(_A);
				break;

			case CPU_INST_ROR_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, ror(READZP(addr8)));
				break;

			case CPU_INST_ROR_ZP_X:
				addr8 = READINC_X(_PC);
				WRITEZP(addr8, ror(READZP(addr8)));
				break;

			case CPU_INST_ROR_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, ror(READ(addr16)));
				break;

			case CPU_INST_ROR_ABS_X:
				addr16 = fetchAbsX();
				WRITE(addr16, ror(READ(addr16)));
				break;

			/*---- CLA ----------------------------------------------------------*/
			case CPU_INST_CLA:
				_A = 0;
				break;

			/*---- CLX ----------------------------------------------------------*/
			case CPU_INST_CLX:
				_X = 0;
				break;

			/*---- CLY ----------------------------------------------------------*/
			case CPU_INST_CLY:
				_Y = 0;
				break;

			/*---- TAX ----------------------------------------------------------*/
			case CPU_INST_TAX:
				tax();
				break;

			/*---- TAY ----------------------------------------------------------*/
			case CPU_INST_TAY:
				tay();
				break;

			/*---- TSX ----------------------------------------------------------*/
			case CPU_INST_TSX:
				tsx();
				break;

			/*---- TXA ----------------------------------------------------------*/
			case CPU_INST_TXA:
				txa();
				break;

			/*---- TXS ----------------------------------------------------------*/
			case CPU_INST_TXS:
				_S = _X;
				break;

			/*---- TYA ----------------------------------------------------------*/
			case CPU_INST_TYA:
				tya();
				break;

			/*---- SAX ----------------------------------------------------------*/
			case CPU_INST_SAX:
				ureg8 = _A;
				_A = _X;
				_X = ureg8;
				break;

			/*---- SAY ----------------------------------------------------------*/
			case CPU_INST_SAY:
				ureg8 = _A;
				_A = _Y;
				_Y = ureg8;
				break;

			/*---- SXY ----------------------------------------------------------*/
			case CPU_INST_SXY:
				ureg8 = _X;
				_X = _Y;
				_Y = ureg8;
				break;

			/*-------------------------------------------------------------------**
			** test instructions
			**-------------------------------------------------------------------*/
			/*---- BIT ----------------------------------------------------------*/
			case CPU_INST_BIT_IMM:
				ureg8 = READINC(_PC);
				bit(ureg8);
				break;

			case CPU_INST_BIT_ZP:
				addr8 = READINC(_PC);
				bit(READZP(addr8));
				break;

			case CPU_INST_BIT_ZP_X:
				addr8 = READINC_X(_PC);
				bit(READZP(addr8));
				break;

			case CPU_INST_BIT_ABS:
				addr16 = fetchAbs();
				bit(READ(addr16));
				break;

			case CPU_INST_BIT_ABS_X:
				addr16 = fetchAbsX();
				bit(READ(addr16));
				break;

			/*---- TRB ----------------------------------------------------------*/
			case CPU_INST_TRB_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, trb(READZP(addr8)));
				break;

			case CPU_INST_TRB_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, trb(READ(addr16)));
				break;

			/*---- TSB ----------------------------------------------------------*/
			case CPU_INST_TSB_ZP:
				addr8 = READINC(_PC);
				WRITEZP(addr8, tsb(READZP(addr8)));
				break;

			case CPU_INST_TSB_ABS:
				addr16 = fetchAbs();
				WRITE(addr16, tsb(READ(addr16)));
				break;

			/*---- TST ----------------------------------------------------------*/
			case CPU_INST_TST_IMM_ZP:
				ureg8 = READINC(_PC);
				addr8 = READINC(_PC);
				tst(ureg8, READZP(addr8));
				break;

			case CPU_INST_TST_IMM_ZP_X:
				ureg8 = READINC(_PC);
				addr8 = READINC_X(_PC);
				tst(ureg8, READZP(addr8));
				break;

			case CPU_INST_TST_IMM_ABS:
				ureg8 = READINC(_PC);
				addr16 = fetchAbs();
				tst(ureg8, READ(addr16));
				break;

			case CPU_INST_TST_IMM_ABS_X:
				ureg8 = READINC(_PC);
				addr16 = fetchAbsX();
				tst(ureg8, READ(addr16));
				break;

			/*-------------------------------------------------------------------**
			** branch / jump instructions
			**-------------------------------------------------------------------*/
			/*---- BCC ----------------------------------------------------------*/
			case CPU_INST_BCC_REL:
				rel8 = (Sint8)READINC(_PC);
				if (_CF == 0)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BNE ----------------------------------------------------------*/
			case CPU_INST_BNE_REL:
				rel8 = (Sint8)READINC(_PC);
				if (_ZF) //ZF0̏ꍇ^([)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BVC ----------------------------------------------------------*/
			case CPU_INST_BVC_REL:
				rel8 = (Sint8)READINC(_PC);
				if ((_VF & CPU_VF) == 0)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BPL ----------------------------------------------------------*/
			case CPU_INST_BPL_REL:
				rel8 = (Sint8)READINC(_PC);
				if ((_NF & CPU_NF) == 0)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BCS ----------------------------------------------------------*/
			case CPU_INST_BCS_REL:
				rel8 = (Sint8)READINC(_PC);
				if (_CF)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BEQ ----------------------------------------------------------*/
			case CPU_INST_BEQ_REL:
				rel8 = (Sint8)READINC(_PC);
				if (_ZF == 0) //ZF0̏ꍇ^([)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BVS ----------------------------------------------------------*/
			case CPU_INST_BVS_REL:
				rel8 = (Sint8)READINC(_PC);
				if (_VF & CPU_VF)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BMI ----------------------------------------------------------*/
			case CPU_INST_BMI_REL:
				rel8 = (Sint8)READINC(_PC);
				if (_NF & CPU_NF)
				{
					gCPU_ClockCount--;
					gCPU_ClockCount--;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BRA ----------------------------------------------------------*/
			case CPU_INST_BRA_REL:
				rel8 = (Sint8)READINC(_PC);
				_PC += (Sint16)rel8;
				break;

			/*---- JMP ----------------------------------------------------------*/
			case CPU_INST_JMP_ABS:
				_PC = fetchAbs();
				break;

			case CPU_INST_JMP_INDIR:
				_PC = fetchAbsIndirect();
				break;

			case CPU_INST_JMP_INDIRX:
				_PC = fetchAbsIndirectX();
				break;

			/*---- BBRi ---------------------------------------------------------*/
			case CPU_INST_BBR0_ZP_REL:
				BBRi(0x01);
				break;

			case CPU_INST_BBR1_ZP_REL:
				BBRi(0x02);
				break;

			case CPU_INST_BBR2_ZP_REL:
				BBRi(0x04);
				break;

			case CPU_INST_BBR3_ZP_REL:
				BBRi(0x08);
				break;

			case CPU_INST_BBR4_ZP_REL:
				BBRi(0x10);
				break;

			case CPU_INST_BBR5_ZP_REL:
				BBRi(0x20);
				break;

			case CPU_INST_BBR6_ZP_REL:
				BBRi(0x40);
				break;

			case CPU_INST_BBR7_ZP_REL:
				BBRi(0x80);
				break;

			/*---- BBSi ---------------------------------------------------------*/
			case CPU_INST_BBS0_ZP_REL:
				BBSi(0x01);
				break;

			case CPU_INST_BBS1_ZP_REL:
				BBSi(0x02);
				break;

			case CPU_INST_BBS2_ZP_REL:
				BBSi(0x04);
				break;

			case CPU_INST_BBS3_ZP_REL:
				BBSi(0x08);
				break;

			case CPU_INST_BBS4_ZP_REL:
				BBSi(0x10);
				break;

			case CPU_INST_BBS5_ZP_REL:
				BBSi(0x20);
				break;

			case CPU_INST_BBS6_ZP_REL:
				BBSi(0x40);
				break;

			case CPU_INST_BBS7_ZP_REL:
				BBSi(0x80);
				break;

			/*-------------------------------------------------------------------**
			** subroutine instructions
			**-------------------------------------------------------------------*/
			/*---- BSR ----------------------------------------------------------*/
			case CPU_INST_BSR_REL: //v1.59XV
				push(_PC >> 8);
				push(_PC & 0xFF);
				rel8 = (Sint8)READINC(_PC);
				_PC += (Sint16)rel8;
				break;

			/*---- JSR ----------------------------------------------------------*/
			case CPU_INST_JSR_ABS: //v1.59XV
				++_PC;
				push(_PC >> 8);
				push(_PC & 0xFF);
				--_PC;
				_PC = fetchAbs();
				break;

			/*---- PHA ----------------------------------------------------------*/
			case CPU_INST_PHA:
				push(_A);
				break;

			/*---- PHP ----------------------------------------------------------*/
			case CPU_INST_PHP:
				_TF = 0;
				push(gatherFlags());
				break;

			/*---- PHX ----------------------------------------------------------*/
			case CPU_INST_PHX:
				push(_X);
				break;

			/*---- PHY ----------------------------------------------------------*/
			case CPU_INST_PHY:
				push(_Y);
				break;

			/*---- PLA ----------------------------------------------------------*/
			case CPU_INST_PLA:
				_A = pull();
				updateFlagZN(_A);
				break;

			/*---- PLP ----------------------------------------------------------*/
			// PLP ߎśF
			// - T tOZbgȂ 
			case CPU_INST_PLP:
				separateFlags(pull());
				_BF = CPU_BF; //v1.61ǉBThanks Aladar's information.
				refreshPrevIF(); //v1.61ǉB炭RTIƓ@\B
				return;

			/*---- PLX ----------------------------------------------------------*/
			case CPU_INST_PLX:
				_X = pull();
				updateFlagZN(_X);
				break;

			/*---- PLY ----------------------------------------------------------*/
			case CPU_INST_PLY:
				_Y = pull();
				updateFlagZN(_Y);
				break;

			/*---- RTI ----------------------------------------------------------*/
			// RTI ߎs
			// - T tOZbgȂ 
			// KitaoǋL - ItO(IF)AƂPrevIFIFƓlɂȂBpullIF0Ȃ΁Ǎシ荞ݏNB
			//			   Ki񂩂炢(CLIߎɂ͂PߒxĊ荞݂N邪ARTI͂Ɋ荞݂N)̓ɈvBv1.61
			case CPU_INST_RTI:
				separateFlags(pull());
				_BF = CPU_BF; //v1.61ǉBThanks Aladar's information.
				refreshPrevIF(); //v1.61ǉ
				_PC = pull();
				_PC |= pull() << 8;
				return;

			/*---- RTS ----------------------------------------------------------*/
			case CPU_INST_RTS:
				_PC = pull();
				_PC |= pull() << 8;
				++_PC;
				break;

			/*-------------------------------------------------------------------**
			** block data transfer instructions
			**-------------------------------------------------------------------*/
			/*---- TII ----------------------------------------------------------*/
			case CPU_INST_TII:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				gCPU_Transfer = 1; //KitaoǉB1=TIIߓ]Jn̍}B
				return;

			/*---- TDD ----------------------------------------------------------*/
			case CPU_INST_TDD:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				gCPU_Transfer = 2; //KitaoǉB2=TDDߓ]Jn̍}B
				return;

			/*---- TIN ----------------------------------------------------------*/
			case CPU_INST_TIN:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				gCPU_Transfer = 3; //KitaoǉB3=TINߓ]Jn̍}B
				return;

			/*---- TIA ----------------------------------------------------------*/
			case CPU_INST_TIA:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_TransferIncDec = TRUE;
				gCPU_Transfer = 4; //KitaoǉB4=TIAߓ]Jn̍}B
				return;

			/*---- TAI ----------------------------------------------------------*/
			case CPU_INST_TAI:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_TransferIncDec = TRUE;
				gCPU_Transfer = 5; //KitaoǉB5=TAIߓ]Jn̍}B
				return;

			/*-------------------------------------------------------------------**
			** mapper instructions
			**-------------------------------------------------------------------*/
			/*---- TAMi ---------------------------------------------------------*/
			case CPU_INST_TAM:
				ureg8 = READINC(_PC);
//if ((ureg8 != 0x01)&&(ureg8 != 0x02)&&(ureg8 != 0x04)&&(ureg8 != 0x08)&&(ureg8 != 0x10)&&(ureg8 != 0x20)&&(ureg8 != 0x40)&&(ureg8 != 0x80))
//PRINTF("TAM %d",ureg8);//test
				if (ureg8 & 0x01) _MPR[0] = _A; //KitaoXVBMPR͍13VtgAAWX^̒l̂܂ܕێ悤ɂBBv1.47
				if (ureg8 & 0x02) _MPR[1] = _A;
				if (ureg8 & 0x04) _MPR[2] = _A;
				if (ureg8 & 0x08) _MPR[3] = _A;
				if (ureg8 & 0x10) _MPR[4] = _A;
				if (ureg8 & 0x20) _MPR[5] = _A;
				if (ureg8 & 0x40) _MPR[6] = _A;
				if (ureg8 & 0x80) _MPR[7] = _A;
				//KitaoǋLBureg8̕bitĂꍇǂȂ邩B͑SĂZbg悤ɂBȂ\tg̋Ɗ֌W邩BveXgB
				break;

			/*---- TMAi ---------------------------------------------------------*/
			case CPU_INST_TMA:
				ureg8 = READINC(_PC);
//if ((ureg8 != 0x01)&&(ureg8 != 0x02)&&(ureg8 != 0x04)&&(ureg8 != 0x08)&&(ureg8 != 0x10)&&(ureg8 != 0x20)&&(ureg8 != 0x40)&&(ureg8 != 0x80))
//PRINTF("TMA %d",ureg8);//test
				if (ureg8 & 0x80) { _A = (Uint8)_MPR[7]; break; }
				if (ureg8 & 0x40) { _A = (Uint8)_MPR[6]; break; }
				if (ureg8 & 0x20) { _A = (Uint8)_MPR[5]; break; }
				if (ureg8 & 0x10) { _A = (Uint8)_MPR[4]; break; }
				if (ureg8 & 0x08) { _A = (Uint8)_MPR[3]; break; }
				if (ureg8 & 0x04) { _A = (Uint8)_MPR[2]; break; }
				if (ureg8 & 0x02) { _A = (Uint8)_MPR[1]; break; }
				if (ureg8 & 0x01) { _A = (Uint8)_MPR[0]; break; }
				//KitaoǋLBureg8̕bitĂꍇǂȂ邩Bv1.59獂rbgŏIIɎc肻Ȃ̂ŁArbgD悷悤ɂB
				break;

			/*-------------------------------------------------------------------**
			** control instructions
			**-------------------------------------------------------------------*/
			/*---- CSL ----------------------------------------------------------*/
			case CPU_INST_CSL: //KitaoǉBԑ҂ȂǂŎgꍇB
				if (_bSpeedLow == FALSE) //v0.85ǉBHighLowɂȂƂ͎sɃNbNς̂ŏNbNϑIɂȂ
				{
					gCPU_ClockCount -= 9;
					SetSpeedLow(TRUE);
				}
				break;

			/*---- CSH ----------------------------------------------------------*/
			case CPU_INST_CSH: //KitaoǉBԑ҂ȂǂŎgꍇB
				if (_bSpeedLow) //v0.85ǉBLowHighɂȂƂ͎sɃNbNς̂ŏNbNϑIɂȂ
				{
					gCPU_ClockCount -= 6;
					SetSpeedLow(FALSE);
				}
				break;

			/*---- BRK ----------------------------------------------------------*/
			case CPU_INST_BRK:
				_PC++;
				push(_PC >> 8);
				push(_PC & 0xFF);
				_TF = 0; //KitaoXVBTtONAĂpushBv1.07
				_BF = CPU_BF;
				push(gatherFlags());
				_IF = CPU_IF;
				refreshPrevIF(); //v1.61ǉ
				_DF = 0;
				_PC  = READ(CPU_IRQ2VECTOR);
				_PC |= READ(CPU_IRQ2VECTOR + 1) << 8;
				break;

			/*---- NOP ----------------------------------------------------------*/
			case CPU_INST_NOP:
				break;

			/*---- RMBi ---------------------------------------------------------*/
			case CPU_INST_RMB0_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x01);
				break;

			case CPU_INST_RMB1_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x02);
				break;

			case CPU_INST_RMB2_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x04);
				break;

			case CPU_INST_RMB3_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x08);
				break;

			case CPU_INST_RMB4_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x10);
				break;

			case CPU_INST_RMB5_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x20);
				break;

			case CPU_INST_RMB6_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x40);
				break;

			case CPU_INST_RMB7_ZP:
				ureg8 = READINC(_PC);
				RMBi(ureg8, 0x80);
				break;

			/*---- SMBi ---------------------------------------------------------*/
			case CPU_INST_SMB0_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x01);
				break;

			case CPU_INST_SMB1_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x02);
				break;

			case CPU_INST_SMB2_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x04);
				break;

			case CPU_INST_SMB3_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x08);
				break;

			case CPU_INST_SMB4_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x10);
				break;

			case CPU_INST_SMB5_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x20);
				break;

			case CPU_INST_SMB6_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x40);
				break;

			case CPU_INST_SMB7_ZP:
				ureg8 = READINC(_PC);
				SMBi(ureg8, 0x80);
				break;

			/*------------------------------------------------------------------**
			** invalid instructions
			**------------------------------------------------------------------*/
			default:
				//PRINTF("CPU ERROR::invalid instructions"); //KitaoǉBv1.07
				break;
		}
		_TF = 0;
		return;

	case 1: //TII
		gCPU_ClockCount -= 5; //lNX̗vǂOPfOKBQWʐMOKB_uhSIIOPfOKB
		ureg8 = READINC(_TransferSrcAddr);
		WRITEINC(_TransferDstAddr, ureg8);
		if (--_TransferLength <= 0) //]SďIȂ
		{
			gCPU_Transfer = 0;
			_TF = 0;
			refreshPrevIF(); //v1.62ǉ
		}
		return;
	case 2: //TDD
		gCPU_ClockCount -= 5;
		ureg8 = READDEC(_TransferSrcAddr);
		WRITEDEC(_TransferDstAddr, ureg8);
		if (--_TransferLength <= 0) //]SďIȂ
		{
			gCPU_Transfer = 0;
			_TF = 0;
			refreshPrevIF(); //v1.62ǉ
		}
		return;
	case 3: //TIN
		gCPU_ClockCount -= 5;
		ureg8 = READINC(_TransferSrcAddr);
		WRITE(_TransferDstAddr, ureg8);
		if (--_TransferLength <= 0) //]SďIȂ
		{
			gCPU_Transfer = 0;
			_TF = 0;
			refreshPrevIF(); //v1.62ǉ
		}
		return;
	case 4: //TIA
		ureg8 = READINC(_TransferSrcAddr);
		if (_TransferIncDec)
		{
			gCPU_ClockCount -= 5; //6ƃ_[ŗ
			WRITEINC(_TransferDstAddr, ureg8);
			_TransferIncDec = FALSE;
		}
		else
		{
			gCPU_ClockCount -= 6; ///[X^'91~[g6ȏオKvB6Ń_[OKB[hXLIĨGfBO6ȏオKv(5łVCEEFCgOK)Bv1.61XV
								  //"WriteAhX"INCDEC̔f{TIIxH(@)
			WRITEDEC(_TransferDstAddr, ureg8);
			_TransferIncDec = TRUE;
		}
		if (--_TransferLength <= 0) //]SďIȂ
		{
			gCPU_Transfer = 0;
			_TF = 0;
			refreshPrevIF(); //v1.62ǉBōXVȂƃbNIŒeoȂB炭@l̓ŁA]߂͂QߕȏɂȂ邽߂̎ԂŐM(tO)XVB
		}
		return;
	case 5: //TAI
		if (_TransferIncDec)
		{
			gCPU_ClockCount -= 5;
			_TransferIncDec = FALSE;
			ureg8 = READINC(_TransferSrcAddr);
		}
		else
		{
			gCPU_ClockCount -= 6; //6ŃTUACYOPŉsb^B5,7ƗdL̃MuʂŗB7ȏゾSUPERSQ̃^CgʂŏӗBv1.62XV
								  //"ReadAhX"INCDEC̔f{TIIxH(@)
			_TransferIncDec = TRUE;
			ureg8 = READDEC(_TransferSrcAddr);
		}
		WRITEINC(_TransferDstAddr, ureg8);
		if (--_TransferLength <= 0) //]SďIȂ
		{
			gCPU_Transfer = 0;
			_TF = 0;
			refreshPrevIF(); //v1.62ǉ
		}
		return;
	}
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
// save array
#define SAVE_A(A)	if (fwrite(A, sizeof(A), 1, p) != 1)	return FALSE
#define LOAD_A(A)	if (fread(A, sizeof(A), 1, p) != 1)		return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		bot̏Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
CPU_SaveState(
	FILE*		p)
{
	BOOL	bTurboCycle = FALSE;

	if (p == NULL)
		return FALSE;

	SAVE_V(_A);
	SAVE_V(_X);
	SAVE_V(_Y);
	SAVE_V(_S);
	SAVE_V(_P);
	SAVE_V(_CF);
	SAVE_V(_ZF);
	SAVE_V(_IF);
	SAVE_V(_PrevIF); //v1.61ǉ
	SAVE_V(_DF);
	SAVE_V(_BF);
	SAVE_V(_TF);
	SAVE_V(_VF);
	SAVE_V(_NF);
	SAVE_V(_PC);
	SAVE_A(_MPR);

	SAVE_V(_bRDY);
	SAVE_V(_bIRQ1);
	SAVE_V(_bIRQ2);
	SAVE_V(_bNMI);
	SAVE_V(_bTIRQ);
	SAVE_V(_IntDisable); //v0.64ǉ
	SAVE_V(_bPrevIRQ1); //v1.61ǉ
	SAVE_V(_bPrevIRQ2); //v1.61ǉ
	SAVE_V(_bPrevTIRQ); //v1.61ǉ
	SAVE_V(_PrevIntDisable); //v1.61ǉ

	SAVE_V(gCPU_Transfer); //Kitaoǉ
	SAVE_V(_TransferSrcAddr); //Kitaoǉ
	SAVE_V(_TransferDstAddr); //Kitaoǉ
	SAVE_V(_TransferLength); //Kitaoǉ
	SAVE_V(_TransferIncDec); //Kitaoǉ

	SAVE_V(gCPU_ClockCount); //Kitaoǉ
	SAVE_V(_ClockElapsed); //Kitaoǉ
	SAVE_V(_bSpeedLow); //Kitaoǉ
	SAVE_V(bTurboCycle); //KitaoǉBv1.61gpɁB

	SAVE_V(_SelectVDC); //v0.89ǉ

	return TRUE;
}

/*-----------------------------------------------------------------------------
	[LoadState]
		bot̏Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
CPU_LoadState(
	FILE*		p)
{
	int		i;
	BOOL	bTurboCycle;

	if (p == NULL)
		return FALSE;

	LOAD_V(_A);
	LOAD_V(_X);
	LOAD_V(_Y);
	LOAD_V(_S);
	LOAD_V(_P);
	LOAD_V(_CF);
	LOAD_V(_ZF);
	LOAD_V(_IF);
	if (MAINBOARD_GetStateVersion() >= 34) //v1.61betaȍ~̃Z[ut@CȂ
	{
		LOAD_V(_PrevIF);
	}
	else //o[W̃Xe[gǂ񂾏ꍇ
		_PrevIF = _IF;
	LOAD_V(_DF);
	LOAD_V(_BF);
	LOAD_V(_TF);
	LOAD_V(_VF);
	LOAD_V(_NF);
	LOAD_V(_PC);
	LOAD_A(_MPR);
	for (i=0; i<8; i++)
		if (_MPR[i] > 0xFF)
			_MPR[i] >>= 13; //v1.47ÕZ[uf[^ꍇAMPRVtgĂ̂߂B

	LOAD_V(_bRDY);
	LOAD_V(_bIRQ1);
	LOAD_V(_bIRQ2);
	LOAD_V(_bNMI);
	LOAD_V(_bTIRQ);
	if (MAINBOARD_GetStateVersion() >= 8) //KitaoǉBv0.64ȍ~̃Z[ut@CȂ
		LOAD_V(_IntDisable); //o[WXe[g̏ꍇIntCtrl.c _IntDisableݒ肳B
	if (MAINBOARD_GetStateVersion() >= 35) //v1.61ȍ~̃Z[ut@CȂ
	{
		LOAD_V(_bPrevIRQ1);
		LOAD_V(_bPrevIRQ2);
		LOAD_V(_bPrevTIRQ);
	}
	else //o[W̃Xe[gǂ񂾏ꍇ
	{
		_bPrevIRQ1 = _bIRQ1;
		_bPrevIRQ2 = _bIRQ2;
		_bPrevTIRQ = _bTIRQ;
	}
	if (MAINBOARD_GetStateVersion() >= 34) //v1.61betaȍ~̃Z[ut@CȂ
	{
		LOAD_V(_PrevIntDisable);
	}
	else //o[W̃Xe[gǂ񂾏ꍇ
		_PrevIntDisable = _IntDisable;

	LOAD_V(gCPU_Transfer); //Kitaoǉ
	LOAD_V(_TransferSrcAddr); //Kitaoǉ
	LOAD_V(_TransferDstAddr); //Kitaoǉ
	LOAD_V(_TransferLength); //Kitaoǉ
	LOAD_V(_TransferIncDec); //Kitaoǉ

	LOAD_V(gCPU_ClockCount); //Kitaoǉ
	LOAD_V(_ClockElapsed); //Kitaoǉ
	if (MAINBOARD_GetStateVersion() < 34) //v1.61betaÕZ[ut@CȂ
		gCPU_ClockCount -= _ClockElapsed;//v1.61fobOȊOgpɁBo[WXe[g̏ꍇAŗ܂ĂB
	LOAD_V(_bSpeedLow); //Kitaoǉ
	LOAD_V(bTurboCycle); //KitaoǉBv1.61gpɁB
	CPU_SetTurboCycle(0); //^[{TCNItɂȂ݂x(_bSpeedLow)ɍ킹ďTCNZbgBv1.61ǉ

	if (MAINBOARD_GetStateVersion() >= 17) //KitaoǉBv0.89ȍ~̃Z[ut@CȂ
	{
		LOAD_V(_SelectVDC);
	}
	else
		_SelectVDC = 0;

	return TRUE;
}

#undef SAVE_V
#undef SAVE_A
#undef LOAD_V
#undef LOAD_A
